﻿package  {
	
	import flash.display.*;	
	
	public class QualityMeter extends MovieClip {
		
		// Constants:
		// Public Properties:
		// Private Properties:
		// UI Elements:
		var signals : Array;
		
		// Initialization:
		public function QualityMeter() {
			signals = [new Bitmap(new Signal0(0, 0)),
					   new Bitmap(new Signal1(0, 0)),
					   new Bitmap(new Signal2(0, 0)),
					   new Bitmap(new Signal3(0, 0)),
					   new Bitmap(new Signal4(0, 0)),
					   new Bitmap(new Signal5(0, 0))];
			
			for(var i = 0; i < signals.length; i++){
				signals[i].x = -16;
				signals[i].y = -16;
			}
		}
	
		public function setConnected(){
			statusLabel.visible = false;
			this.addChildAt(signals[0], 0);
		}
		
		public function setDisconnected(){
			statusLabel.visible = true;
			this.removeChildAt(0);
		}

		// Public Methods:
		public function updateSignalQuality(value : Number){
			if(statusLabel.visible == true)
				return;
			
			if(value >= 0 && value < 25)
				swapSignalGraphic(signals[5]);
			else if(value >= 25 && value < 50)
				swapSignalGraphic(signals[4]);
			else if(value >= 50 && value < 75)
				swapSignalGraphic(signals[3]);
			else if(value >= 75 && value < 100)
				swapSignalGraphic(signals[2]);
			else if(value >= 100 && value < 200)
				swapSignalGraphic(signals[1]);
			else if(value >= 200)
				swapSignalGraphic(signals[0]);
		}
					
		// Protected Methods:
		// Private Methods:
		private function swapSignalGraphic(b : Bitmap){
			this.removeChildAt(0);
			this.addChildAt(b, 0);
		}
	}
	
}